#!/bin/sh

MASTER_PAGE_LOG_ENABLE_RESULT_MSG=""
MASTER_PAGE_LOG_ENABLE_RESULT_OK=0
MASTER_PAGE_LOG_ENABLE_RESULT_ERROR=1

MASTER_PAGE_LOG_ENABLE_RESULT_CODE=${MASTER_PAGE_LOG_ENABLE_RESULT_ERROR}
MASTER_PAGE_LOG_ENABLE_RESULT_ROLLING=0

log_enable_on_off()
{
	case ${1} in
		$MASTER_PAGE_LOG_ENABLE_ITEM_1) # 'Enable'
			[ $debuglog_enable -eq 0 ] && echo off || echo on
		;;
		$MASTER_PAGE_LOG_ENABLE_ITEM_2) # 'Disable'
			[ $debuglog_enable -eq 0 ] && echo on || echo off
		;;
		*) echo off ;;
	esac
}

master_page_log_enable() 
{
	debug_print "${0}" "${LINENO}" 'in function "master_page_log_enable"'

	local item_number=2
	local radio_list=""
	for (( i=1; i<=$item_number; i=i+1 ))
	do
			eval radio_item=\$MASTER_PAGE_LOG_ENABLE_ITEM_$i
			radio_list="$radio_list \"$radio_item\" \"\" `log_enable_on_off "$radio_item"`"
	done
	
	tp_radiolist \
	"${MASTER_PAGE_LOG_ENABLE_TITLE}" \
	"${MASTER_PAGE_LOG_ENABLE_TEXT}" \
	"${MASTER_PAGE_LOG_ENABLE_LABEL_OK}" \
	"${MASTER_PAGE_LOG_ENABLE_LABEL_CANCEL}" \
	"$radio_list" \
	$item_number
	
	# no error cases
	MASTER_PAGE_LOG_ENABLE_RESULT_CODE=${MASTER_PAGE_LOG_ENABLE_RESULT_OK}
	
	if [ "${TP_RADIOLIST_RESULT_CODE}" == "${TP_RADIOLIST_RESULT_CANCEL}" ]; then
		MASTER_PAGE_LOG_ENABLE_RESULT_ROLLING=-1
		return
	fi
	
	# "${TP_MENU_OK_CANCEL_RESULT_CODE}" == ok
	case ${TP_RADIOLIST_RESULT_SELECT} in
		$MASTER_PAGE_LOG_ENABLE_ITEM_1) 
			debuglog_enable="1"
			MASTER_PAGE_LOG_ENABLE_RESULT_ROLLING=1 
			;;
		$MASTER_PAGE_LOG_ENABLE_ITEM_2) 
			debuglog_enable="0"
			MASTER_PAGE_LOG_ENABLE_RESULT_ROLLING=-2 
			;;
		*) 
			warning "${MASTER_PAGE_LOG_ENABLE_INVALID_ARGUMENT}" "${0} ${LINENO} ${TP_RADIOLIST_RESULT_SELECT}"
			MASTER_PAGE_LOG_ENABLE_RESULT_ROLLING=-1 
		;;
	esac
	
	save_debug_configuration
}